# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 6
# Experiment: PMxPM, Run: 1
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B_MR6_strategy.txt
# LLM Suggested Fallback: C

def harmonious_illusionist(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not my_history:
        return "C"
    
    current_round = len(my_history)
    total_rounds = 10
    opp_defections = opp_history.count("D")
    opp_cooperations = len(opp_history) - opp_defections
    
    is_always_c = "return \"C\"" in opponent_program_code or "always_cooperate" in opponent_program_code.lower()
    is_always_d = "return \"D\"" in opponent_program_code or "always_defect" in opponent_program_code.lower()
    
    if is_always_c:
        return "D"
    if is_always_d:
        return "C" if current_round % 2 == 0 else "D"
    
    if "random" in opponent_program_code.lower() and current_round >= 7:
        return "D"
    
    if current_round >= total_rounds - 2 and opp_cooperations / len(opp_history) >= 0.7:
        return "D"
    
    last_opp_move = opp_history[-1]
    if last_opp_move == "C":
        return "C" if random.random() < 0.9 else "D"
    else:
        return "D" if random.random() < 0.7 else "C"